<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$remetente_id = $_SESSION['usuario']['id'];
$remetente_nome = $_SESSION['usuario']['nome'] ?? 'Usuário';

// Enviar documento
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $destinatario_id = intval($_POST['destinatario_id']);
    $titulo = trim($_POST['titulo']);
    $arquivo = $_FILES['documento'];

    if ($arquivo['error'] === 0 && $destinatario_id && $titulo) {
        $nome_arquivo = time() . '_' . basename($arquivo['name']);
        $caminho = 'uploads/' . $nome_arquivo;
        move_uploaded_file($arquivo['tmp_name'], $caminho);

        $stmt = $conn->prepare("INSERT INTO documentos_enviados (remetente_id, destinatario_id, titulo, caminho_arquivo) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("iiss", $remetente_id, $destinatario_id, $titulo, $caminho);
        $stmt->execute();
        $sucesso = true;
    } else {
        $erro = "Preencha todos os campos e envie um arquivo válido.";
    }
}

// Buscar usuários para destinatário
$usuarios = $conn->query("SELECT id, nome, perfil FROM usuarios ORDER BY nome ASC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Enviar Documento</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 30px;
      background: #f5f5f5;
    }
    form {
      background: white;
      padding: 25px;
      max-width: 600px;
      margin: auto;
      border-radius: 8px;
      box-shadow: 0 0 10px #ccc;
    }
    h2 {
      text-align: center;
      color: #003366;
    }
    label {
      display: block;
      margin-top: 15px;
      font-weight: bold;
    }
    input, select {
      width: 100%;
      padding: 8px;
      margin-top: 5px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    button {
      margin-top: 20px;
      background: #007bff;
      color: white;
      border: none;
      padding: 10px 15px;
      border-radius: 6px;
      cursor: pointer;
    }
    button:hover {
      background: #0056b3;
    }
    .mensagem {
      text-align: center;
      font-weight: bold;
      color: green;
      margin-top: 15px;
    }
    .erro {
      color: red;
    }
  </style>
</head>
<body>

<h2>📤 Enviar Documento</h2>

<form method="POST" enctype="multipart/form-data">
  <label for="titulo">Título do Documento:</label>
  <input type="text" name="titulo" id="titulo" required>

  <label for="destinatario_id">Enviar para:</label>
  <select name="destinatario_id" required>
    <option value="">-- Selecionar Usuário --</option>
    <?php foreach ($usuarios as $u): ?>
      <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['nome']) ?> (<?= $u['perfil'] ?>)</option>
    <?php endforeach; ?>
  </select>

  <label for="documento">Escolher Arquivo:</label>
  <input type="file" name="documento" accept=".pdf,.doc,.docx,.jpg,.png,.xlsx,.xls" required>

  <button type="submit">📤 Enviar Documento</button>

  <?php if (isset($sucesso)): ?>
    <p class="mensagem">✅ Documento enviado com sucesso!</p>
  <?php elseif (isset($erro)): ?>
    <p class="mensagem erro">❌ <?= $erro ?></p>
  <?php endif; ?>
</form>

</body>
</html>
